<?php

namespace App\Http\Controllers\Dashboard\Admin;

use App\Helpers\AdminHelper;
use App\Models\Contact;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Mail\ContactMessage;
use App\Models\Admin;
use Illuminate\Support\Facades\Mail;

class ContactController extends Controller
{
    public function index()
    {
        $contacts = Contact::latest()->get();
        $admin = Admin::where('id', auth('admin')->user()->id)->first();

        $data = [
            'title' => 'Contact Messages',
            'contacts' => $contacts,
            'admin' => $admin
        ];

        return view('dashboard.admin.contact.index', $data);
    }

    public function show($uuid)
    {
        $contact = Contact::where('uuid', $uuid)->first();
        $admin = Admin::where('id', auth('admin')->user()->id)->first();

        $data = [
            'title' => 'Contact Message Details',
            'contact' => $contact,
            'admin' => $admin
        ];

        return view('dashboard.admin.contact.show', $data);
    }

    public function send(Request $request, $uuid)
    {

        $request->validate([
            'message' => 'required',
        ]);

        $contact = Contact::where('uuid', $uuid)->first();
        $reply = $request->message;

        try {
            AdminHelper::mailConfig(auth('admin')->user()->id);
            Mail::to($contact->email)->send(new ContactMessage($contact, $reply, 'Replying to your message' . now()));
            return redirect()->back()->with('success', 'Message sent successfully');
        } catch (\Exception $e) {
            session()->flash('email_error', 'Failed to send email. ' . $e->getMessage());
        }


        return redirect()->back();
    }

    public function delete($uuid)
    {
        $contact = Contact::where('uuid', $uuid)->first();
        $contact->delete();
        return redirect()->back()->with('success', 'Message deleted successfully!');
    }
}
