<?php

namespace App\Http\Controllers\Dashboard\Admin;

use App\Models\Admin;
use App\Models\Contact;
use App\Models\Shipment;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class DashboardController extends Controller
{
    public function index()
    {
        $shipment = new Shipment();
        $contact = new Contact();
        $shipmentsCount = $shipment::count();
        $shipmentOnHoldCount = $shipment->where('status', 'OnHold')->count();
        $shipmentOutForDeliveryCount = $shipment->where('status', 'OutForDelivery')->count();
        $shipmentInTransitCount = $shipment->where('status', 'InTransit')->count();
        $shipmentEnRouteCount = $shipment->where('status', 'EnRoute')->count();
        $shipmentCancelledCount = $shipment->where('status', 'Cancelled')->count();
        $shipmentDeliveredCount = $shipment->where('status', 'Delivered')->count();
        $shipmentReturnedCount = $shipment->where('status', 'Returned')->count();
        $shipmentArrivedCount = $shipment->where('status', 'Arrived')->count();
        $contactMessagesCount = $contact::count();
        $admin = Admin::where('id', auth('admin')->user()->id)->first();
        $data = [
            'title' => 'Dashboard',
            'shipmentsCount' => $shipmentsCount,
            'shipmentOnHoldCount' => $shipmentOnHoldCount,
            'shipmentOutForDeliveryCount' => $shipmentOutForDeliveryCount,
            'shipmentInTransitCount' => $shipmentInTransitCount,
            'shipmentEnRouteCount' => $shipmentEnRouteCount,
            'shipmentCancelledCount' => $shipmentCancelledCount,
            'shipmentDeliveredCount' => $shipmentDeliveredCount,
            'shipmentReturnedCount' => $shipmentReturnedCount,
            'shipmentArrivedCount' => $shipmentArrivedCount,
            'contactMessagesCount' => $contactMessagesCount,
            'admin' => $admin
        ];
        return view('dashboard.admin.index', $data);
    }

    public function profile()
    {
        $data = [
            'title' => 'Profile',
            'admin' => Admin::findOrFail(Auth::guard('admin')->user()->id),
        ];

        return view('dashboard.admin.profile', $data);
    }

    public function profileUpdate(Request $request)
    {
        $request->validate([
            'name' => 'required',
            'email' => 'required|email',

        ]);

        $admin = Admin::findOrFail(Auth::guard('admin')->user()->id);
        $admin->name = $request->name;
        $admin->email = $request->email;
        $admin->save();
        return redirect()->back()->with('success', 'Profile updated successfully');
    }
}
