<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ShipmentRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'sender_name' => 'nullable|string',
            'sender_address' => 'nullable|string',
            'sender_phone' => 'nullable|string',
            'sender_email' => 'nullable|email',
            'client_name' => 'nullable|string',
            'client_address' => 'nullable|string',
            'client_phone' => 'nullable|string',
            'client_email' => 'nullable|email',
            'description' => 'nullable|string',
            'shipped_from' => 'nullable|string',
            'shipment_amount' => 'nullable|numeric',
            'expected_delivery_date' => 'nullable|date',
            'pickup_location' => 'nullable|string',
            'date_of_shipment' => 'nullable|date',
            'quantity' => 'nullable|numeric',
            'length' => 'nullable|numeric',
            'width' => 'nullable|numeric',
            'height' => 'nullable|numeric',
            'pickup_time' => 'nullable|string',
            'departure_time' => 'nullable|string',
            'comment' => 'nullable|string',
            'type_of_shipment' => 'required|string',
            'total_freight' => 'nullable|numeric',
            'payment_mode' => 'required|string',
            'mode' => 'required|string',
            'carrier_reference_no' => 'required|string',
            'carrier' => 'required|string',
            'product' => 'nullable|string',
            'weight' => 'nullable|numeric',
            'image' => 'nullable|image|max:2024|mimes:png,jpg,jpeg',
            'currency' => 'nullable|string',
        ];
    }

    /**
     * Get custom messages for validator errors.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'image.max' => 'Oops, you cannot upload a file that is more than 2MB',
            'image.image' => 'Only images can be uploaded',
        ];
    }
}
