<?php

namespace Database\Factories;

use Illuminate\Support\Facades\Hash;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Admin>
 */
class AdminFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'uuid'                  => $this->faker->uuid,
            'name'                  => $this->faker->userName,
            'email'                 => $this->faker->unique()->safeEmail,
            'password'              => Hash::make('password'),
            'status'                => true,
            'created_at'            => now(),
            'updated_at'            => now(),
        ];
    }
}
// MAIL_MAILER=smtp
// MAIL_HOST=sandbox.smtp.mailtrap.io
// MAIL_PORT=2525
// MAIL_USERNAME=8eba1b62b2a97d
// MAIL_PASSWORD=2a8ae793797dd0
// MAIL_ENCRYPTION=tls
// MAIL_FROM_ADDRESS="hello@example.com"
// MAIL_FROM_NAME="${APP_NAME}"
