<?php

namespace Database\Seeders;

use Illuminate\Support\Str;
use Illuminate\Database\Seeder;
use App\Models\ShipmentLocation;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class ShipmentLocationTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        ShipmentLocation::updateOrCreate(
            [
                'id' => 1
            ],
            [
                'uuid' => Str::uuid(),
                'shipment_id' => 1,
                'status' => 'PickedUp',
                'location' => 'South Korea',
                'google_map_location' => 'https://maps.google.com/?q=South Korea',
                'description' => 'Picked up from South Korea',
                'date' => '2024-06-28',
                'time' => '10:00 AM',
                'created_at' => now(),
                'updated_at' => now(),
            ]
        );
    }
}
