@extends('dashboard.admin.layouts.master')
@section('content')
    <section class="section">
        @include('dashboard.admin.partials.banner_area')
        <div class="section-body">
            <div class="row">
                <div class="col-12">
                    @include('partials.validation_message')
                    <form action="{{ route('admin.shipment.update', @$shipment->uuid) }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="card mb-4">
                            <div class="card-header">
                                <h4>Sender information</h4>
                                <div class="card-header-action">
                                    <a href="{{ route('admin.shipment.show', @$shipment->uuid) }}"
                                        class="btn btn-primary">Back</a>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="sender_name">Name:</label>
                                    <input class="form-control" placeholder="The sender name" type="text"
                                        value="{{ @$shipment->sender_name }}" name="sender_name" id="sender_name">
                                    <small>The sender name</small> <br>
                                </div>
                                <div class="form-group">
                                    <label for="sender_address">Address:</label>
                                    <input class="form-control" placeholder="The sender address" type="text"
                                        value="{{ @$shipment->sender_address }}" name="sender_address" id="sender_address">
                                    <small>The sender address</small> <br>

                                </div>
                                <div class="form-group">
                                    <label for="sender_phone">Phone:</label>
                                    <input class="form-control" placeholder="The sender phone number" type="text"
                                        value="{{ @$shipment->sender_phone }}" name="sender_phone" id="sender_phone">
                                    <small>The sender phone number</small> <br>

                                </div>
                                <div class="form-group">
                                    <label for="sender_email">Email:</label>
                                    <input class="form-control" placeholder="The sender email" type="text"
                                        value="{{ @$shipment->sender_email }}" name="sender_email" id="sender_email">
                                    <small>The sender email</small> <br>

                                </div>
                            </div>
                        </div>

                        <div class="card mt-4 mb-4">
                            <div class="card-header">
                                <h4>Client information</h4>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="client_name">Name:</label>
                                    <input class="form-control" placeholder="The client name" type="text"
                                        value="{{ @$shipment->client_name }}" name="client_name" id="client_name">
                                    <small>The client name</small> <br>

                                </div>
                                <div class="form-group">
                                    <label for="client_address">Address:</label>
                                    <input class="form-control" placeholder="The client address" type="text"
                                        value="{{ @$shipment->client_address }}" name="client_address" id="client_address">
                                    <small>The client address</small> <br>

                                </div>
                                <div class="form-group">
                                    <label for="client_phone">Phone:</label>
                                    <input class="form-control" placeholder="The client phone number" type="text"
                                        value="{{ @$shipment->client_phone }}" name="client_phone" id="client_phone">
                                    <small>The client phone number</small> <br>

                                </div>
                                <div class="form-group">
                                    <label for="client_email">Email:</label>
                                    <input class="form-control" placeholder="The client email" type="text"
                                        value="{{ @$shipment->client_email }}" name="client_email" id="client_email">
                                    <small>The client email</small> <br>

                                </div>
                            </div>
                        </div>

                        <div class="card mt-4 mb-4">
                            <div class="card-header">
                                <h5 class="m-0 p-0">Parcel information</h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label>Description:</label>
                                    <textarea class="form-control" name="description" id="description" cols="30" rows="10"
                                        placeholder="The description of the parcel">{{ @$shipment->description }}</textarea>
                                    <small id="helpId" class="d-block text-muted">The description of parcel or what it
                                        contains</small>

                                </div>
                                <div class="row">
                                    <div class="col-sm-12 col-md-6">
                                        <div class="form-group">
                                            <label>Weight:</label>
                                            <input type="text" name="weight" value="{{ @$shipment->weight }}"
                                                class="form-control" placeholder="">
                                            <small id="helpId" class="d-block text-muted">The weight of the
                                                parcel</small>
                                        </div>
                                        <div class="form-group">
                                            <label>Shipment Amount:</label>
                                            <input type="text" name="shipment_amount"
                                                value="{{ @$shipment->shipment_amount }}" class="form-control"
                                                placeholder="">
                                            <small id="helpId" class="d-block text-muted">The amount used for shipping
                                                this
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Pickup location:</label>
                                            <select class="form-control select2" name="pickup_location">
                                                <option value="">Select</option>
                                                @foreach (config('setting.nationality') as $key => $pickupLocation)
                                                    <option value="{{ $pickupLocation }}"
                                                        {{ @$shipment->pickup_location == $pickupLocation ? 'selected' : '' }}>
                                                        {{ $pickupLocation }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            <small id="helpId" class="d-block text-muted">The address this parcel will
                                                be
                                                delivered</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Quantity:</label>
                                            <input type="text" name="quantity" value="{{ @$shipment->quantity }}"
                                                class="form-control" placeholder="">
                                            <small id="helpId" class="d-block text-muted">The quantity of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Length:</label>
                                            <input type="text" name="length" value="{{ @$shipment->length }}"
                                                class="form-control" placeholder="">
                                            <small id="helpId" class="d-block text-muted">The length of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Width:</label>
                                            <input type="text" name="width" value="{{ @$shipment->width }}"
                                                class="form-control" placeholder="">
                                            <small id="helpId" class="d-block text-muted">The width of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Height:</label>
                                            <input type="text" name="height" value="{{ @$shipment->height }}"
                                                class="form-control" placeholder="">
                                            <small id="helpId" class="d-block text-muted">The height of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Shipped from:</label>
                                            <select class="form-control select2" name="shipped_from">
                                                <option value="">Select</option>
                                                @foreach (config('setting.nationality') as $key => $shippedFrom)
                                                    <option value="{{ $shippedFrom }}"
                                                        {{ @$shipment->shipped_from == $shippedFrom ? 'selected' : '' }}>
                                                        {{ $shippedFrom }}
                                                    </option>
                                                @endforeach
                                            </select>
                                            <small id="helpId" class="d-block text-muted">The country the shipment is
                                                coming
                                                from.</small>
                                        </div>
                                        <div class="form-group">
                                            <label>Expected date of Delivery:</label>
                                            <input type="text" name="expected_delivery_date"
                                                value="{{ @$shipment->expected_delivery_date }}"
                                                class="form-control datepicker" placeholder="">
                                            <small id="helpId" class="d-block text-muted">The expected day of delivery
                                                of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Date of shipment:</label>
                                            <input type="text" name="date_of_shipment"
                                                value="{{ @$shipment->date_of_shipment }}" class="form-control datepicker"
                                                placeholder="">
                                            <small id="helpId" class="d-block text-muted">The date of shipping this
                                                parcel</small>

                                        </div>
                                    </div>
                                    <div class="col-sm-12 col-md-6">
                                        <div class="form-group">
                                            <label>Pick Up Time:</label>
                                            <input type="text" name="pickup_time"
                                                value="{{ @$shipment->pickup_time }}" class="form-control timepicker"
                                                placeholder="">
                                            <small id="helpId" class="d-block text-muted">The pickup time of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Departure Time:</label>
                                            <input type="text" name="departure_time"
                                                value="{{ @$shipment->departure_time }}" class="form-control timepicker"
                                                placeholder="">
                                            <small id="helpId" class="d-block text-muted">The departure time of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Comment:</label>
                                            <textarea name="comment" id="comment" cols="30" rows="10" class="form-control">{{ @$shipment->comment }}</textarea>
                                            <small id="helpId" class="d-block text-muted">The comment of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Type Of Shipment:</label>
                                            <select name="type_of_shipment" id="type_of_shipment"
                                                class="form-control select2">
                                                <option value="{{ @$shipment->type_of_shipment }}">
                                                    {{ @$shipment->type_of_shipment }}
                                                </option>
                                                <option value="Air Freight">Air Freight</option>
                                                <option value="International Shipping">International Shipping</option>
                                                <option value="Truck Load">Truck Load</option>
                                                <option value="Van Move">Van Move</option>
                                            </select>
                                            <small id="helpId" class="d-block text-muted">The type of shipment of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Total Freight:</label>
                                            <input type="text" name="total_freight"
                                                value="{{ @$shipment->total_freight }}" class="form-control"
                                                placeholder="">
                                            <small id="helpId" class="d-block text-muted">The total freight of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Payment Mode:</label>
                                            <select name="payment_mode" id="payment_mode" class="form-control select2">
                                                <option value="{{ @$shipment->payment_mode }}">
                                                    {{ @$shipment->payment_mode }}
                                                </option>
                                                <option value="Cash">Cash</option>
                                                <option value="Cheque">Cheque</option>
                                                <option value="BACS">BACS</option>
                                                <option value="Online Banking Transfer">Online Banking Transfer</option>
                                            </select>
                                            <small id="helpId" class="d-block text-muted">The payment mode of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Product:</label>
                                            <input type="text" name="product" value="{{ @$shipment->product }}"
                                                class="form-control" placeholder="Packages">
                                            <small id="helpId" class="d-block text-muted">The product of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Mode:</label>
                                            <select name="mode" id="mode" class="form-control select2">
                                                <option value="{{ @$shipment->mode }}">{{ @$shipment->mode }}</option>
                                                <option value="Sea Transport">Sea Transport</option>
                                                <option value="Land Shipping">Land Shipping</option>
                                                <option value="Air Freight">Air Freight</option>
                                            </select>
                                            <small id="helpId" class="d-block text-muted">The mode of the
                                                parcel</small>
                                        </div>
                                        <div class="form-group">
                                            <label>Carrier Reference No:</label>
                                            <input type="text" name="carrier_reference_no"
                                                value="{{ @$shipment->carrier_reference_no }}" id="carrier_reference_no"
                                                class="form-control" placeholder="">
                                            <small id="helpId" class="d-block text-muted">The carrier reference no of
                                                the
                                                parcel</small>
                                        </div>
                                        <div class="form-group">
                                            <label>Carrier:</label>
                                            <select name="carrier" id="carrier" class="form-control select2">
                                                <option value="{{ @$shipment->carrier }}">{{ @$shipment->carrier }}
                                                </option>
                                                <option value="DHL">DHL</option>
                                                <option value="USPS">Land Shipping</option>
                                                <option value="FedEx">FedEx</option>
                                                <option value="{{ config('app.name') }}">{{ config('app.name') }}
                                                </option>
                                            </select>
                                            <small id="helpId" class="d-block text-muted">The carrier of the
                                                parcel</small>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label>Currency:</label>
                                        <select class="form-control select2" name="currency">
                                            <option value="">Select</option>
                                            @foreach (config('setting.currency') as $key => $currency)
                                                <option
                                                    value="{{ $currency['name'] }}-{{ $currency['code'] }}-{{ $currency['symbol'] }}"
                                                    {{ @$shipment->currency == $currency['name'] . '-' . $currency['code'] . '-' . $currency['symbol'] ? 'selected' : '' }}>
                                                    {{ $currency['name'] }}
                                                </option>
                                            @endforeach
                                        </select>

                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>Parcel image:</label>
                                        <input type="file" name="image" value="" class="form-control"
                                            placeholder="The sender address">
                                        <small id="helpId" class="d-block text-muted">The image of the parcel</small>
                                        <img class="img-fluid w-25 mt-5"
                                            src="{{ asset('uploads/shipments/' . @$shipment->image) }}">

                                    </div>
                                </div>
                                <div class="form-group">
                                    <button type="submit" class="btn btn-sm btn-primary">{{ $title }}</button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
@endsection
