@extends('dashboard.admin.layouts.master')
@section('content')
    <section class="section">
        @include('dashboard.admin.partials.banner_area')

        <div class="section-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>{{ $title }}</h4>
                            <div class="card-header-action">
                                <a href="{{ route('admin.shipment.create') }}" class="btn btn-primary"><i
                                        class="fas fa-plus"></i>
                                    Add Shipment</a>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-striped" id="table-1">
                                    <thead>
                                        <tr>
                                            <th>
                                                #
                                            </th>
                                            <th>Tracking Code</th>
                                            <th>Sender Name</th>
                                            <th>Client Name</th>
                                            <th>Shipment Date</th>
                                            <th>Carrier</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($shipments as $key => $shipment)
                                            <tr>
                                                <td>{{ $key + 1 }}</td>
                                                <td><a
                                                        href="{{ route('admin.shipment.show', @$shipment->uuid) }}">{{ @$shipment->tracking_code }}</a>
                                                </td>
                                                <td>{{ @$shipment->sender_name }}</td>
                                                <td>{{ @$shipment->client_name }}</td>
                                                <td>{{ @$shipment->date_of_shipment }}</td>
                                                <td>{{ @$shipment->carrier }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
