@extends('dashboard.master.layouts.master')
@section('content')
    <section class="section">
        <div class="section-header">
            <h1>Master Dashboard</h1>
        </div>
        <div class="row">
            <div class="col-12">
                @include('partials.validation_message')
                <div class="card">
                    <div class="card-header">
                        {{ $title }}
                    </div>
                    <div class="card-body">
                        <form action="{{ route('master.admin.update', $admin->uuid) }}" class="user" method="POST">
                            @csrf
                            <div class="form-group">
                                <label for="name">Name</label>
                                <input type="name" class="form-control" id="name" name="name"
                                    placeholder="Enter name" value="{{ $admin->name }}">
                            </div>
                            <div class="form-group">
                                <label for="email">Email</label>
                                <input type="email" class="form-control" id="email" name="email"
                                    placeholder="Email Address" value="{{ $admin->email }}">
                            </div>
                            <div class="form-group">
                                <label for="password">Password</label>
                                <input type="text" class="form-control" id="password" name="password"
                                    placeholder="Password">
                            </div>
                            <div class="form-group">
                                <label>SMTP User</label>
                                <input type="text" placeholder="SMTP User" value="{{ $admin->smtp_user }}"
                                    name="smtp_user" class="form-control">
                            </div>
                            <div class="form-group">
                                <label>SMTP Password</label>
                                <input type="text" placeholder="SMTP Password" value="{{ $admin->smtp_password }}"
                                    name="smtp_password" class="form-control">
                            </div>
                            <div class="form-group">
                                <label>SMTP Host</label>
                                <input type="text" placeholder="SMTP Host" value="{{ $admin->smtp_host }}"
                                    name="smtp_host" class="form-control">
                            </div>
                            <div class="form-group">
                                <label>SMTP Port</label>
                                <input type="text" placeholder="SMTP Port" value="{{ $admin->smtp_port }}"
                                    name="smtp_port" class="form-control">
                            </div>
                            <div class="form-group">
                                <label>SMTP Encryption</label>
                                <select name="smtp_encryption" id="smtp_encryption" class="form-control">
                                    <option value="">Select</option>
                                    <option value="tls" {{ $admin->smtp_encryption == 'tls' ? 'selected' : '' }}>
                                        TLS</option>
                                    <option value="ssl" {{ $admin->smtp_encryption == 'ssl' ? 'selected' : '' }}>
                                        SSL</option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Status</label>
                                <select class="form-control" name="status">
                                    <option value="">Select</option>
                                    <option value="1" {{ $admin->status == 1 ? 'selected' : '' }}>ACTIVE
                                    </option>
                                    <option value="0" {{ $admin->status == 0 ? 'selected' : '' }}>INACTIVE
                                    </option>
                                </select>
                            </div>
                            <div class="form-group">
                                <label>Live Chat</label>
                                <textarea name="live_chat" class="form-control" id="live_chat">
                              {{ $admin->live_chat }}
                              </textarea>
                            </div>
                            <button type="submit" class="btn btn-primary">Update</button>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </section>
@endsection
