@extends('layouts.master')
@section('content')
    <section id="page-title" class="page-title page-title-layout4 text-center bg-overlay bg-parallax">
        <div class="bg-img"><img src="/assets/img/page-titles/1.jpg" alt="background"></div>
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-md-12 col-lg-12 col-xl-8 offset-xl-2">
                    <span class="pagetitle__subheading">Frequently Asked Questions</span>
                    <h1 class="pagetitle__heading">Professional Logistics and Delivery
                    </h1>
                </div>
            </div>
        </div>
    </section>

    <section id="about2" class="about about-2">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <div class="faq_question_list">
                        <div class="faq_item">
                            <h4>What is a freight forwarder?</h4>
                            <p>A freight forwarder is a company that organizes shipments for individuals or corporations to
                                get goods from the manufacturer or producer to a market, customer, or final point of
                                distribution. They act as intermediaries between the shipper and transportation services,
                                handling documentation, customs clearance, and more.</p>
                        </div>
                        <div class="faq_item">
                            <h4>Who is the consignee and who is the consignor or shipper?</h4>
                            <p>The consignor, also known as the shipper, is the person or company that sends goods for
                                delivery. The consignee, on the other hand, is the person or company that receives the goods
                                upon arrival at the destination.</p>
                        </div>
                        <div class="faq_item">
                            <h4>Does my shipment need any special packaging for freight shipping?</h4>
                            <p>Yes, depending on the type of goods being shipped, special packaging may be required for safe
                                and secure transportation. Fragile items, hazardous materials, or perishable goods may need
                                specific packaging guidelines to ensure they arrive intact.</p>
                        </div>
                        <div class="faq_item">
                            <h4>Do I need to know the weight of my goods?</h4>
                            <p>Yes, knowing the weight of your goods is crucial for determining shipping costs and selecting
                                the appropriate transportation method. Freight carriers often use weight as a primary factor
                                in calculating shipping charges.</p>
                        </div>
                        <div class="faq_item">
                            <h4>Does size matter for air shipment?</h4>
                            <p>Yes, both weight and size are important factors for air shipments. Airlines have specific
                                guidelines for maximum dimensions and weights for cargo, and exceeding these limits can
                                affect shipping costs and feasibility.</p>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="faq_question_list">
                        <div class="faq_item">
                            <h4>How is chargeable weight calculated?</h4>
                            <p>Chargeable weight is typically calculated based on the actual weight or the volumetric weight
                                of the shipment, whichever is greater. Volumetric weight considers the volume of the package
                                in relation to its weight, ensuring fair pricing for bulky but lightweight items.</p>
                        </div>
                        <div class="faq_item">
                            <h4>What is the maximum size or weight?</h4>
                            <p>The maximum size and weight of shipments can vary depending on the carrier, mode of
                                transportation, and destination. It's essential to check with your freight forwarder or
                                carrier for specific guidelines to avoid any issues during shipping.</p>
                        </div>
                        <div class="faq_item">
                            <h4>Can you ship my vehicle internationally?</h4>
                            <p>Yes, many freight forwarders offer international vehicle shipping services. They can help
                                with the necessary documentation, customs clearance, and transportation arrangements to get
                                your vehicle safely to its destination.</p>
                        </div>
                        <div class="faq_item">
                            <h4>Do you have a warehouse where I can drop off the cargo?</h4>
                            <p>Yes, we have warehouses and distribution centers strategically located to facilitate drop-off
                                and storage of cargo. This allows for convenient and secure handling of your goods before
                                they are shipped to their final destination.</p>
                        </div>
                        <div class="faq_item">
                            <h4>How and where can we pick up the cargo at the destination?</h4>
                            <p>Upon arrival at the destination, you can arrange for pickup of your cargo at our designated
                                facilities or specified locations. Our team will provide you with detailed instructions and
                                assistance for a smooth and efficient pickup process.</p>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
@endsection
