<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta http-equiv="X-UA-Compatible" content="ie=edge">
        <style>
            body {
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                background-color: #f5f5f5;
                margin: 0;
                padding: 0;
            }

            .container {
                max-width: 600px;
                margin: 20px auto;
                background-color: #fff;
                border-radius: 5px;
                box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            }

            .header {
                background-color: #003366;
                padding: 10px;
                border-top-left-radius: 5px;
                border-top-right-radius: 5px;
                color: #fff;
            }

            .logo {
                text-align: center;
                margin-bottom: 20px;
            }

            .logo img {
                max-width: 300px;
            }

            .content {
                padding: 30px;
                color: #333;
            }

            h2 {
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                font-size: 24px;
                margin-bottom: 20px;
            }

            p {
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                font-size: 16px;
                margin-bottom: 20px;
                line-height: 1.5;
            }

            .button {
                display: inline-block;
                padding: 12px 24px;
                background-color: #4CAF50;
                color: #fff;
                text-decoration: none;
                border-radius: 4px;
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                font-size: 16px;
            }

            .button:hover {
                background-color: #45a049;
            }

            .footer {
                background-color: #f5f5f5;
                padding: 20px;
                text-align: center;
                font-size: 14px;
                color: #777;
                line-height: 1.5;
            }

            .footer p {
                margin: 0;
            }

            .footer .contact-info {
                margin-top: 10px;
            }

            .footer .contact-info a {
                color: #777;
                text-decoration: none;
            }

            .signature {
                margin-top: 30px;
                text-align: center;
                font-style: italic;
                color: #888;
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            }
        </style>
    </head>

    <body>
        <div class='container'>
            <div class='header'>
                <div class='logo'>
                    <img src='<?php echo e(asset('logo/logo.png')); ?>' alt='<?php echo e(config('app.name')); ?>'>
                </div>
            </div>
            <div class='content'>
                <p>Dear <?php echo e($shipment->client_name); ?>,</p>
                <p>Good day!</p>
                <p>We trust this mail meets you well. This is to bring to your notice that your shipment with tracking
                    number <strong><?php echo e($shipment->tracking_code); ?></strong> from
                    <strong><?php echo e($shipment->sender_name); ?></strong>, current status is
                    <strong><?php echo e($shipment->status); ?></strong>. Please visit <a
                        href="<?php echo e(route('cargo.tracking.details', $shipment->uuid)); ?>"
                        target="_blank"><?php echo e(config('app.url')); ?></a>
                    for more details.
                </p>

            </div>
            <div class='footer'>
                <p>Thank you for choosing <?php echo e(config('app.name')); ?>.</p>
                <p>This email should not be used by anyone who is not the original intended recipient. It may contain
                    confidential, proprietary or legally information.</p>
            </div>
        </div>
    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\logistics-v3.1\resources\views\mail\shipment_notification.blade.php ENDPATH**/ ?>