<?php $__env->startSection('content'); ?>
    <section class="section">
        <?php echo $__env->make('dashboard.admin.partials.banner_area', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <div class="section-body">
            <div class="invoice">
                <div class="invoice-print">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="invoice-title">
                                <h2>Tracking Code: <span class="text-success"><?php echo e(@$shipment->tracking_code); ?></span></h2>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-6">
                                    <address>
                                        <strong>From:</strong><br>
                                        <?php echo e(@$shipment->sender_name); ?><br>
                                        <?php echo e(@$shipment->sender_address); ?><br>
                                        <?php echo e(@$shipment->sender_phone); ?><br>
                                        <?php echo e(@$shipment->sender_email); ?>

                                    </address>
                                </div>
                                <div class="col-md-6 text-md-right">
                                    <address>
                                        <strong>Shipped To:</strong><br>
                                        <?php echo e(@$shipment->client_name); ?><br>
                                        <?php echo e(@$shipment->client_address); ?><br>
                                        <?php echo e(@$shipment->client_phone); ?><br>
                                        <?php echo e(@$shipment->client_email); ?>

                                    </address>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <address>
                                        <strong>Payment Mode:</strong><br>
                                        <?php echo e(@$shipment->payment_mode); ?>

                                    </address>
                                </div>
                                <div class="col-md-6 text-md-right">
                                    <address>
                                        <strong>Shipment Date:</strong><br>
                                        <?php echo e(date('d F Y', strtotime(@$shipment->date_of_shipment))); ?><br><br>
                                    </address>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-striped table-hover table-md">
                                    <tr>
                                        <th class="text-center">Type Of Shipment</th>
                                        <th class="text-center">Shipped From</th>
                                        <th class="text-center">Pickup Location</th>
                                        <th class="text-center">Expected Delivery Date</th>
                                        <th class="text-center">Departure Time</th>
                                        <th class="text-center">Pickup Time</th>
                                    </tr>
                                    <tr>
                                        <td class="text-center"><?php echo e(@$shipment->type_of_shipment); ?></td>
                                        <td class="text-center"><?php echo e(@$shipment->shipped_from); ?></td>
                                        <td class="text-center"><?php echo e(@$shipment->pickup_location); ?></td>
                                        <td class="text-center">
                                            <?php echo e(date('d F Y', strtotime(@$shipment->expected_delivery_date))); ?></td>
                                        <td class="text-center"><?php echo e(date('H:i A', strtotime(@$shipment->departure_time))); ?>

                                        </td>
                                        <td class="text-center"><?php echo e(date('H:i A', strtotime(@$shipment->pickup_time))); ?></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover table-md">
                                    <tr>
                                        <th class="text-center">Quantity</th>
                                        <th class="text-center">Length</th>
                                        <th class="text-center">Width</th>
                                        <th class="text-center">Height</th>
                                        <th class="text-center">Comment</th>
                                        <th class="text-center">Description</th>
                                    </tr>
                                    <tr>
                                        <td class="text-center"><?php echo e(@$shipment->quantity); ?></td>
                                        <td class="text-center"><?php echo e(@$shipment->length); ?></td>
                                        <td class="text-center"><?php echo e(@$shipment->width); ?></td>
                                        <td class="text-center"><?php echo e(@$shipment->height); ?></td>
                                        <td class="text-center"><?php echo e(@$shipment->comment); ?></td>
                                        <td class="text-center"><?php echo e(@$shipment->description); ?></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="table-responsive">
                                <table class="table table-striped table-hover table-md">
                                    <tr>
                                        <th class="text-center">Product</th>
                                        <th class="text-center">Mode</th>
                                        <th class="text-center">Carrier Reference Number</th>
                                        <th class="text-center">Carrier</th>
                                        <th class="text-center">Status</th>
                                        <th class="text-center">Current Location</th>
                                    </tr>
                                    <tr>
                                        <td class="text-center"><?php echo e(@$shipment->product); ?></td>
                                        <td class="text-center"><?php echo e(@$shipment->mode); ?></td>
                                        <td class="text-center"><?php echo e(@$shipment->carrier_reference_no); ?></td>
                                        <td class="text-center"><?php echo e(@$shipment->carrier); ?></td>
                                        <td class="text-center"><?php echo e(@$shipment->status); ?></td>
                                        <td class="text-center"><?php echo e(@$shipment->current_location); ?></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="row mt-4">
                                <div class="col-lg-8">
                                    <img class="img-fluid w-50" src="<?php echo e(asset('uploads/shipments/' . @$shipment->image)); ?>"
                                        alt="">

                                </div>
                                <div class="col-lg-4 text-right">
                                    <div class="invoice-detail-item">
                                        <div class="invoice-detail-name">Shipment amount</div>
                                        <div class="invoice-detail-value invoice-detail-value-lg">
                                            <?php echo e(currency(@$shipment->currency) . formatAmount(@$shipment->shipment_amount)); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="text-md-right">
                    <button class="btn btn-primary" data-toggle="modal" data-target="#exampleModal">Update Location</button>
                    <a target="_blank" href="<?php echo e(route('cargo.tracking.details', @$shipment->uuid)); ?>"
                        class="btn btn-info btn-icon icon-left"><i class="fas fa-ship"></i> Track Shipment</a>
                    <a href="<?php echo e(route('admin.shipment.edit', @$shipment->uuid)); ?>"
                        class="btn btn-primary btn-icon icon-left"><i class="fas fa-edit"></i> Edit</a>
                    <a onclick="return confirm('Are you sure?')"
                        href="<?php echo e(route('admin.shipment.delete', @$shipment->uuid)); ?>"
                        class="btn btn-danger btn-icon icon-left"><i class="fas fa-trash"></i> Delete</a>
                    <a target="_blank" href="<?php echo e(route('admin.shipment.print', @$shipment->uuid)); ?>"
                        class="btn btn-warning btn-icon icon-left"><i class="fas fa-print"></i> Print</a>
                </div>
            </div>
            <div class="row">
                <div class="col-12">
                    <?php echo $__env->make('partials.email_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <div class="card">
                        <div class="card-header">
                            <h4>Shipment Location</h4>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table" id="table-1">
                                    <thead>
                                        <tr>
                                            <th>
                                                #
                                            </th>
                                            <th>Status</th>
                                            <th>Location</th>
                                            <th>Google Map Location</th>
                                            <th>Description</th>
                                            <th>Date</th>
                                            <th>Time</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $shipmentLocations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $shipmentLocation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($key + 1); ?></td>
                                                <td><?php echo e($shipmentLocation->status); ?></td>
                                                <td>
                                                    <?php if(@$shipment->current_location == $shipmentLocation->location && @$shipment->status == $shipmentLocation->status): ?>
                                                        Current Location: <span
                                                            class="text-success"><b><?php echo e($shipmentLocation->location); ?></b></span>
                                                    <?php else: ?>
                                                        Previous Location: <span
                                                            class="text-danger"><b><?php echo e($shipmentLocation->location); ?></b></span>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?php echo e($shipmentLocation->google_map_location); ?></td>
                                                <td><?php echo e($shipmentLocation->description); ?></td>
                                                <td><?php echo e(date('d F Y', strtotime($shipmentLocation->date))); ?></td>
                                                <td><?php echo e(date('g:i A', strtotime($shipmentLocation->time))); ?></td>
                                                <td>
                                                    <a onclick="return confirm('Are you sure?')"
                                                        href="<?php echo e(route('admin.shipment.location.delete', $shipmentLocation->uuid)); ?>"
                                                        class="btn btn-danger btn-sm"><i class="fas fa-trash"></i></a>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </section>
    <div class="modal fade" tabindex="-1" role="dialog" id="exampleModal">
        <div class="modal-dialog" role="document">
            <form action="<?php echo e(route('admin.shipment.location.store', @$shipment->uuid)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Update Location</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select name="status" id="status" class="form-control">
                                <option value="">Select</option>
                                <?php $__currentLoopData = $shipmentStatues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipmentStatus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($shipmentStatus->name); ?>"
                                        <?php echo e(@$shipment->status == $shipmentStatus->name ? 'selected' : ''); ?>>
                                        <?php echo e($shipmentStatus->value); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="location">Location</label>
                            <input type="text" class="form-control" name="location">
                        </div>
                        <div class="form-group">
                            <label for="google_map_location">Google Map Location</label>
                            <input type="text" class="form-control" name="google_map_location">
                        </div>
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea name="description" id="description" class="form-control"></textarea>
                        </div>
                        <div class="form-group">
                            <label for="date">Date</label>
                            <input type="text" class="form-control datepicker" name="date">
                        </div>
                        <div class="form-group">
                            <label for="time">Time</label>
                            <input type="text" class="form-control timepicker" name="time">
                        </div>
                        <div class="form-group">
                            <label for="notification">Notification</label>
                            <select name="notification" id="" class="form-control">
                                <option value="None" selected>None</option>
                                <option value="Email">Email</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer bg-whitesmoke">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Update</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\logistics-v3.1\resources\views\dashboard\admin\shipment\show.blade.php ENDPATH**/ ?>