<!DOCTYPE html>
<html lang="en">

    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Contact Us Reply</title>
        <style>
            /* Reset styles */
            body,
            html {
                margin: 0;
                padding: 0;
            }

            /* Simple email styles */
            body {
                font-family: Arial, sans-serif;
                line-height: 1.6;
                background-color: #f4f4f4;
                padding: 20px;
            }

            .container {
                max-width: 600px;
                margin: 0 auto;
                background-color: #ffffff;
                padding: 20px;
                border-radius: 8px;
                box-shadow: 0 2px 5px rgba(0, 0, 0, 0.1);
            }

            h1 {
                color: #333333;
            }

            p {
                margin-bottom: 20px;
            }

            .btn {
                display: inline-block;
                padding: 10px 20px;
                background-color: #007bff;
                color: #ffffff;
                text-decoration: none;
                border-radius: 5px;
            }

            .btn:hover {
                background-color: #0056b3;
            }

            /* Message styles */
            .message {
                background-color: #f9f9f9;
                border-left: 4px solid #007bff;
                padding: 10px;
                margin-top: 20px;
            }
        </style>
    </head>

    <body>
        <div class="container">
            <h1>Replying to Your Message</h1>
            <p>Dear <?php echo e($contact->name); ?>,</p>
            <p>Thank you for contacting us! We have received your message:</p>

            <div class="message">
                <p><strong>Subject:</strong> <?php echo e($contact->subject); ?></p>
                <p><strong>Message:</strong></p>
                <p><?php echo e($contact->message); ?></p>
            </div>

            <div class="message">
                <p><?php echo $reply; ?></p>
            </div>
            <p>If you have any further questions or concerns, feel free to reply to this email or contact us at <a
                    href="mailto:<?php echo e(config('app.email')); ?>"><?php echo e(config('app.email')); ?></a>.</p>
            <p>Best regards,</p>
            <p><?php echo e(config('app.name')); ?></p>
            <a href="<?php echo e(config('app.url')); ?>" class="btn">Visit Our Website</a>
        </div>
    </body>

</html>
<?php /**PATH C:\xampp\htdocs\projects\logistics-v3.1\resources\views\mail\contact_message.blade.php ENDPATH**/ ?>