<?php $__env->startSection('content'); ?>
    <section class="section">
        <?php echo $__env->make('dashboard.admin.partials.banner_area', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <div class="section-body">
            <div class="row">
                <div class="col-12">
                    <?php echo $__env->make('partials.validation_message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <form action="<?php echo e(route('admin.shipment.update', @$shipment->uuid)); ?>" method="POST"
                        enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="card mb-4">
                            <div class="card-header">
                                <h4>Sender information</h4>
                                <div class="card-header-action">
                                    <a href="<?php echo e(route('admin.shipment.show', @$shipment->uuid)); ?>"
                                        class="btn btn-primary">Back</a>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="sender_name">Name:</label>
                                    <input class="form-control" placeholder="The sender name" type="text"
                                        value="<?php echo e(@$shipment->sender_name); ?>" name="sender_name" id="sender_name">
                                    <small>The sender name</small> <br>
                                </div>
                                <div class="form-group">
                                    <label for="sender_address">Address:</label>
                                    <input class="form-control" placeholder="The sender address" type="text"
                                        value="<?php echo e(@$shipment->sender_address); ?>" name="sender_address" id="sender_address">
                                    <small>The sender address</small> <br>

                                </div>
                                <div class="form-group">
                                    <label for="sender_phone">Phone:</label>
                                    <input class="form-control" placeholder="The sender phone number" type="text"
                                        value="<?php echo e(@$shipment->sender_phone); ?>" name="sender_phone" id="sender_phone">
                                    <small>The sender phone number</small> <br>

                                </div>
                                <div class="form-group">
                                    <label for="sender_email">Email:</label>
                                    <input class="form-control" placeholder="The sender email" type="text"
                                        value="<?php echo e(@$shipment->sender_email); ?>" name="sender_email" id="sender_email">
                                    <small>The sender email</small> <br>

                                </div>
                            </div>
                        </div>

                        <div class="card mt-4 mb-4">
                            <div class="card-header">
                                <h4>Client information</h4>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label for="client_name">Name:</label>
                                    <input class="form-control" placeholder="The client name" type="text"
                                        value="<?php echo e(@$shipment->client_name); ?>" name="client_name" id="client_name">
                                    <small>The client name</small> <br>

                                </div>
                                <div class="form-group">
                                    <label for="client_address">Address:</label>
                                    <input class="form-control" placeholder="The client address" type="text"
                                        value="<?php echo e(@$shipment->client_address); ?>" name="client_address" id="client_address">
                                    <small>The client address</small> <br>

                                </div>
                                <div class="form-group">
                                    <label for="client_phone">Phone:</label>
                                    <input class="form-control" placeholder="The client phone number" type="text"
                                        value="<?php echo e(@$shipment->client_phone); ?>" name="client_phone" id="client_phone">
                                    <small>The client phone number</small> <br>

                                </div>
                                <div class="form-group">
                                    <label for="client_email">Email:</label>
                                    <input class="form-control" placeholder="The client email" type="text"
                                        value="<?php echo e(@$shipment->client_email); ?>" name="client_email" id="client_email">
                                    <small>The client email</small> <br>

                                </div>
                            </div>
                        </div>

                        <div class="card mt-4 mb-4">
                            <div class="card-header">
                                <h5 class="m-0 p-0">Parcel information</h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label>Description:</label>
                                    <textarea class="form-control" name="description" id="description" cols="30" rows="10"
                                        placeholder="The description of the parcel"><?php echo e(@$shipment->description); ?></textarea>
                                    <small id="helpId" class="d-block text-muted">The description of parcel or what it
                                        contains</small>

                                </div>
                                <div class="row">
                                    <div class="col-sm-12 col-md-6">
                                        <div class="form-group">
                                            <label>Weight:</label>
                                            <input type="text" name="weight" value="<?php echo e(@$shipment->weight); ?>"
                                                class="form-control" placeholder="">
                                            <small id="helpId" class="d-block text-muted">The weight of the
                                                parcel</small>
                                        </div>
                                        <div class="form-group">
                                            <label>Shipment Amount:</label>
                                            <input type="text" name="shipment_amount"
                                                value="<?php echo e(@$shipment->shipment_amount); ?>" class="form-control"
                                                placeholder="">
                                            <small id="helpId" class="d-block text-muted">The amount used for shipping
                                                this
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Pickup location:</label>
                                            <select class="form-control select2" name="pickup_location">
                                                <option value="">Select</option>
                                                <?php $__currentLoopData = config('setting.nationality'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $pickupLocation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($pickupLocation); ?>"
                                                        <?php echo e(@$shipment->pickup_location == $pickupLocation ? 'selected' : ''); ?>>
                                                        <?php echo e($pickupLocation); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <small id="helpId" class="d-block text-muted">The address this parcel will
                                                be
                                                delivered</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Quantity:</label>
                                            <input type="text" name="quantity" value="<?php echo e(@$shipment->quantity); ?>"
                                                class="form-control" placeholder="">
                                            <small id="helpId" class="d-block text-muted">The quantity of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Length:</label>
                                            <input type="text" name="length" value="<?php echo e(@$shipment->length); ?>"
                                                class="form-control" placeholder="">
                                            <small id="helpId" class="d-block text-muted">The length of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Width:</label>
                                            <input type="text" name="width" value="<?php echo e(@$shipment->width); ?>"
                                                class="form-control" placeholder="">
                                            <small id="helpId" class="d-block text-muted">The width of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Height:</label>
                                            <input type="text" name="height" value="<?php echo e(@$shipment->height); ?>"
                                                class="form-control" placeholder="">
                                            <small id="helpId" class="d-block text-muted">The height of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Shipped from:</label>
                                            <select class="form-control select2" name="shipped_from">
                                                <option value="">Select</option>
                                                <?php $__currentLoopData = config('setting.nationality'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $shippedFrom): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($shippedFrom); ?>"
                                                        <?php echo e(@$shipment->shipped_from == $shippedFrom ? 'selected' : ''); ?>>
                                                        <?php echo e($shippedFrom); ?>

                                                    </option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <small id="helpId" class="d-block text-muted">The country the shipment is
                                                coming
                                                from.</small>
                                        </div>
                                        <div class="form-group">
                                            <label>Expected date of Delivery:</label>
                                            <input type="text" name="expected_delivery_date"
                                                value="<?php echo e(@$shipment->expected_delivery_date); ?>"
                                                class="form-control datepicker" placeholder="">
                                            <small id="helpId" class="d-block text-muted">The expected day of delivery
                                                of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Date of shipment:</label>
                                            <input type="text" name="date_of_shipment"
                                                value="<?php echo e(@$shipment->date_of_shipment); ?>" class="form-control datepicker"
                                                placeholder="">
                                            <small id="helpId" class="d-block text-muted">The date of shipping this
                                                parcel</small>

                                        </div>
                                    </div>
                                    <div class="col-sm-12 col-md-6">
                                        <div class="form-group">
                                            <label>Pick Up Time:</label>
                                            <input type="text" name="pickup_time"
                                                value="<?php echo e(@$shipment->pickup_time); ?>" class="form-control timepicker"
                                                placeholder="">
                                            <small id="helpId" class="d-block text-muted">The pickup time of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Departure Time:</label>
                                            <input type="text" name="departure_time"
                                                value="<?php echo e(@$shipment->departure_time); ?>" class="form-control timepicker"
                                                placeholder="">
                                            <small id="helpId" class="d-block text-muted">The departure time of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Comment:</label>
                                            <textarea name="comment" id="comment" cols="30" rows="10" class="form-control"><?php echo e(@$shipment->comment); ?></textarea>
                                            <small id="helpId" class="d-block text-muted">The comment of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Type Of Shipment:</label>
                                            <select name="type_of_shipment" id="type_of_shipment"
                                                class="form-control select2">
                                                <option value="<?php echo e(@$shipment->type_of_shipment); ?>">
                                                    <?php echo e(@$shipment->type_of_shipment); ?>

                                                </option>
                                                <option value="Air Freight">Air Freight</option>
                                                <option value="International Shipping">International Shipping</option>
                                                <option value="Truck Load">Truck Load</option>
                                                <option value="Van Move">Van Move</option>
                                            </select>
                                            <small id="helpId" class="d-block text-muted">The type of shipment of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Total Freight:</label>
                                            <input type="text" name="total_freight"
                                                value="<?php echo e(@$shipment->total_freight); ?>" class="form-control"
                                                placeholder="">
                                            <small id="helpId" class="d-block text-muted">The total freight of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Payment Mode:</label>
                                            <select name="payment_mode" id="payment_mode" class="form-control select2">
                                                <option value="<?php echo e(@$shipment->payment_mode); ?>">
                                                    <?php echo e(@$shipment->payment_mode); ?>

                                                </option>
                                                <option value="Cash">Cash</option>
                                                <option value="Cheque">Cheque</option>
                                                <option value="BACS">BACS</option>
                                                <option value="Online Banking Transfer">Online Banking Transfer</option>
                                            </select>
                                            <small id="helpId" class="d-block text-muted">The payment mode of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Product:</label>
                                            <input type="text" name="product" value="<?php echo e(@$shipment->product); ?>"
                                                class="form-control" placeholder="Packages">
                                            <small id="helpId" class="d-block text-muted">The product of the
                                                parcel</small>

                                        </div>
                                        <div class="form-group">
                                            <label>Mode:</label>
                                            <select name="mode" id="mode" class="form-control select2">
                                                <option value="<?php echo e(@$shipment->mode); ?>"><?php echo e(@$shipment->mode); ?></option>
                                                <option value="Sea Transport">Sea Transport</option>
                                                <option value="Land Shipping">Land Shipping</option>
                                                <option value="Air Freight">Air Freight</option>
                                            </select>
                                            <small id="helpId" class="d-block text-muted">The mode of the
                                                parcel</small>
                                        </div>
                                        <div class="form-group">
                                            <label>Carrier Reference No:</label>
                                            <input type="text" name="carrier_reference_no"
                                                value="<?php echo e(@$shipment->carrier_reference_no); ?>" id="carrier_reference_no"
                                                class="form-control" placeholder="">
                                            <small id="helpId" class="d-block text-muted">The carrier reference no of
                                                the
                                                parcel</small>
                                        </div>
                                        <div class="form-group">
                                            <label>Carrier:</label>
                                            <select name="carrier" id="carrier" class="form-control select2">
                                                <option value="<?php echo e(@$shipment->carrier); ?>"><?php echo e(@$shipment->carrier); ?>

                                                </option>
                                                <option value="DHL">DHL</option>
                                                <option value="USPS">Land Shipping</option>
                                                <option value="FedEx">FedEx</option>
                                                <option value="<?php echo e(config('app.name')); ?>"><?php echo e(config('app.name')); ?>

                                                </option>
                                            </select>
                                            <small id="helpId" class="d-block text-muted">The carrier of the
                                                parcel</small>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="form-group col-md-6">
                                        <label>Currency:</label>
                                        <select class="form-control select2" name="currency">
                                            <option value="">Select</option>
                                            <?php $__currentLoopData = config('setting.currency'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option
                                                    value="<?php echo e($currency['name']); ?>-<?php echo e($currency['code']); ?>-<?php echo e($currency['symbol']); ?>"
                                                    <?php echo e(@$shipment->currency == $currency['name'] . '-' . $currency['code'] . '-' . $currency['symbol'] ? 'selected' : ''); ?>>
                                                    <?php echo e($currency['name']); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>Parcel image:</label>
                                        <input type="file" name="image" value="" class="form-control"
                                            placeholder="The sender address">
                                        <small id="helpId" class="d-block text-muted">The image of the parcel</small>
                                        <img class="img-fluid w-25 mt-5"
                                            src="<?php echo e(asset('uploads/shipments/' . @$shipment->image)); ?>">

                                    </div>
                                </div>
                                <div class="form-group">
                                    <button type="submit" class="btn btn-sm btn-primary"><?php echo e($title); ?></button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('dashboard.admin.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\projects\logistics-v3.1\resources\views\dashboard\admin\shipment\edit.blade.php ENDPATH**/ ?>